<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

class WPvivid_Google_Service_Drive_CommentList extends WPvivid_Google_Collection
{
  protected $collection_key = 'comments';
  protected $commentsType = 'WPvivid_Google_Service_Drive_Comment';
  protected $commentsDataType = 'array';
  public $kind;
  public $nextPageToken;

  /**
   * @param WPvivid_Google_Service_Drive_Comment
   */
  public function setComments($comments)
  {
    $this->comments = $comments;
  }
  /**
   * @return WPvivid_Google_Service_Drive_Comment
   */
  public function getComments()
  {
    return $this->comments;
  }
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  public function getKind()
  {
    return $this->kind;
  }
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
}
